﻿using System;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP.EFR.BLL;
using VIRP.EFR.BO;

namespace VIRP_WEB.Custom.EFR
{
    public partial class ReferralContactLog : EfrBasePage
    {
        //private ContactLogManager manager = new ContactLogManager();
        //private UserAccountManager user = (UserAccountManager)HttpContext.Current.User;
        Int32 referralId = -1;

        protected override void Page_Load(object sender, EventArgs e)
        {
            int.TryParse(Request.QueryString["referralId"], out referralId);

            SetupCommonDataSourceParameters();

            if (!IsPostBack)
            {
                ((Label)Master.FindControl("EfrPageTitle")).Text = "My Tasks > Contact Logs > All Contacts > Referral # " + referralId.ToString();
            }
        }

        private void SetupCommonDataSourceParameters()
        {
            ObjectDataSourcePatient.SelectParameters["CURRENT_USER"].DefaultValue = CurrentUser;
            ObjectDataSourcePatient.SelectParameters["CURRENT_REGISTRY_ID"].DefaultValue = CurrentRegistryId.ToString();
            ObjectDataSourcePatient.SelectParameters["REFERRAL_ID"].DefaultValue = referralId.ToString();

            ObjectDataSourceEFRReferralContactLog.SelectParameters["CURRENT_USER"].DefaultValue = CurrentUser;
            ObjectDataSourceEFRReferralContactLog.SelectParameters["CURRENT_REGISTRY_ID"].DefaultValue = CurrentRegistryId.ToString();
            ObjectDataSourceEFRReferralContactLog.SelectParameters["id"].DefaultValue = referralId.ToString();
        }

        protected void EFRReferralChatLog_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            if (e.CommandName.Equals("Details"))
            {
                HiddenField hiddenID = (HiddenField)e.Item.FindControl("ContactIDField");
                string id = hiddenID.Value;

                Response.Redirect(string.Format("~/Custom/EFR/Referrals/ReferralContact.aspx?referralId={0}&contactId={1}", referralId, id));
            }
            else if (e.CommandName.Equals("Add"))
            {
                Response.Redirect(string.Format("~/Custom/EFR/Referrals/ReferralContact.aspx?referralId={0}", referralId));
            }
            else if (e.CommandName.Equals("DeleteContact"))
            {
                HiddenField hiddenID = (HiddenField)e.Item.FindControl("ContactIDField");
                string id = hiddenID.Value;

                CONTACT_LOGManager.Delete(CurrentUser, CurrentRegistryId, int.Parse(id));

                string js = "<script type='text/javascript'>alert('Deleted Contact Log entry');</script>";

                ClientScript.RegisterStartupScript(typeof(Page), "alertMessage", js);

                EFRReferralChatLog.DataBind();
            }
        }

        protected void EFRReferralChatLog_DataBound(object source, RepeaterItemEventArgs e)
        {
            if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem
                        || e.Item.ItemType == ListItemType.SelectedItem)
            {
                var cntctlgDt = e.Item.DataItem as ContactLog; //  ContactLogManager.ContactLog;
                if (cntctlgDt != null)
                {
                    var reason = cntctlgDt.ContactReason;
                    if (reason != null)
                    {
                        if (reason.Equals(EFRSharedConstant.ContactLogReasonPrinted)
                        || reason.Equals(EFRSharedConstant.ContactLogReasonUnaccepted))
                        {
                            Button edit = e.Item.FindControl("SelectButton") as Button;
                            if (edit != null)
                                edit.Enabled = false;

                            Button del = e.Item.FindControl("DeleteButton") as Button;

                            if (del != null)
                                del.Enabled = false;
                        }
                    }
                }
            }
        }

        public bool EnableButtton()
        {
            //Only TEFSC Coordinator can delete a contact episode.
            return (UserSession.IsSystemAdministrator || UserSession.IsRegistryAdministrator);
        }
    }
}
